library ProtonLib;

{$E .dll}

uses
  SysUtils,
  Classes,
  Controls,
  Forms,
  dllform in 'dllform.pas' {Form1};

const INTERFACEVERSION =1 ;

      KEINE_RUECKGABE=0; //Programmabbruch ohne Rueckgabe
      RUECKGABE_ERSETZT_MARKIERUNG = 1; // Bedeutet, dass die Rckgabe des Plugins nur den markierten Text ersetzt;
      RUECKGABE_ERSETZT_EDITORTEXT = 2; // Bedeutet, dass die Rckgabe des Plugins den gesamten Text im Editor ersetzt;


function pluginStart(text:pchar; selstart,sellength:integer) : pchar; export;stdcall;
var
  Form1 : TForm1;
begin
  result:=nil;
  lines:=Tstringlist.create;
  if (sellength>0) then
     begin
     RUECKGABETYP:=RUECKGABE_ERSETZT_MARKIERUNG;
     lines.text:=copy(strpas(text), selstart+1, sellength);
     end
  else
    begin
    RUECKGABETYP:=RUECKGABE_ERSETZT_EDITORTEXT;
    lines.Text:=strpas(text);
    end;
  Form1 := TForm1.Create(nil);
  try
    Form1.ShowModal;
    if form1.ModalResult = mrOK then
       begin
            Result := StrNew(pchar(lines.text));
       end
    else RUECKGABETYP:=KEINE_RUECKGABE;
    lines.free;
    Form1.Free;
  except
    //Falls irgendein unerwarteter Fehler auftritt
    RUECKGABETYP:=KEINE_RUECKGABE;
    Result := '';
    lines.free;
    Form1.Free;
  end;
end;



function pluginRueckgabetyp:Integer;export; stdcall;
begin
  Result := RUECKGABETYP; // RUECKGABETYP ist Variable aus UNIT DLLFORM !!
end;


function pluginInterfaceVersion:Integer;export; stdcall;
begin
  Result := INTERFACEVERSION;
end;


//Exportieren der Funktionen aus der dll
exports
pluginRueckgabetyp,
pluginStart,
pluginInterfaceVersion;

end.
