unit dllform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Tabnotbk, Spin;

const INTERFACEVERSION =1 ;

      KEINE_RUECKGABE=0; //PRogrammabbruch ohne Rueckgabe
      RUECKGABE_ERSETZT_MARKIERUNG = 1; // Bedeutet, dass die Rckgabe des Plugins nur den markierten Text ersetzt;
      RUECKGABE_ERSETZT_EDITORTEXT = 2; // Bedeutet, dass die Rckgabe des Plugins den gesamten Text im Editor ersetzt;


type
  TForm1 = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    Button2: TButton;
    Button3: TButton;
    bol: TEdit;
    eol: TEdit;
    Button4: TButton;
    delLB: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    delTabs: TCheckBox;
    delSpaces: TCheckBox;
    Panel1: TPanel;
    Button1: TButton;
    Button5: TButton;
    use_var_number: TCheckBox;
    var_number_start: TSpinEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Button6: TButton;
    Label4: TLabel;
    Button7: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Button8: TButton;
    Label11: TLabel;
    Button9: TButton;
    Label12: TLabel;
    rfillnonauto: TCheckBox;
    rfillsize: TSpinEdit;
    rfillchar: TSpinEdit;
    Label3: TLabel;
    Button10: TButton;
    Label13: TLabel;
    lnumberdigits: TSpinEdit;
    lnumberuserdefine: TCheckBox;
    Label14: TLabel;
    lnumberstart: TSpinEdit;
    Button11: TButton;
    Label15: TLabel;
    inthex: TSpinEdit;
    Button12: TButton;
    Label16: TLabel;
    intbin: TSpinEdit;
    procedure leereZeilenLoeschen(Sender: TObject);
    procedure WhiteSpacesLoeschen(Sender: TObject);
    procedure ZeilenweiseErgaenzen(Sender: TObject);
    procedure trimlines(Sender: TObject);
    procedure deletehtml(Sender: TObject);
    procedure quotemailreply(Sender: TObject);
    procedure makeparagraph(Sender: TObject);
    procedure rfill(Sender: TObject);
    procedure makelinenumbers(Sender: TObject);
    procedure inserthex(Sender: TObject);
    procedure insertbin(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

VAR
 RUECKGABETYP:integer;
 lines:tstrings;

implementation

{$R *.DFM}

Function replacesubstr(Const intext: String; this, withthat: String; CaseSensitive: boolean): String;
var i,le,lt,ls,start:longint;
    hit:boolean;
    ups,uptext:string;
    worktext:string;
begin
lt:=length(intext);
ls:=length(this);
le:=length(withthat);
start:=1;
i:=start;
hit:=false;
ups:=uppercase(this);
worktext:=intext;
uptext:=uppercase(intext);
if (length(intext)>0) and (length(this)>0) then
 while i<=lt-ls+1 do
 begin
 if caseSensitive then
   begin
    if worktext[i]=this[1] then
      if copy(worktext,i,ls)=this then hit:=true;
   end
  else
   begin
    if uptext[i]=ups[1] then
      if copy(uptext,i,ls)=ups then hit:=true;
   end;
 if hit then
   begin
   delete(worktext,i,ls);
   insert(withthat,worktext,i);
   lt:=length(worktext);
   i:=i+le-ls;
   hit:=false;
   if not caseSensitive then uptext:=uppercase(worktext);
   end;
 inc(i);
 end;
result:=worktext;
end;


Function deletehtmlcodes(t: String): String;
Var
  i: longint;
  stop: boolean;
Begin
  If t <> '' Then
  Begin
    i := 0;
    Repeat
      If t[i] = '<' Then
      Begin
        stop := false;
        Repeat
          If t[i] = '>' Then stop := true;
          delete(t, i, 1);
        Until stop Or (i > length(t));
      End Else inc(i);
    Until i > length(t);
  End;
  result := t;
End;




procedure TForm1.leereZeilenLoeschen(Sender: TObject);
var i:integer;
begin
i:=0;
while i<lines.Count do
      begin
          if (lines[i]='') then
             lines.Delete(i)
          else inc(i);
      end;
end;

procedure TForm1.ZeilenweiseErgaenzen(Sender: TObject);
var i:integer;
begin
i:=0;
while i<lines.Count do
      begin
           lines[i]:=bol.Text+lines[i]+eol.text;
           if use_var_number.Checked then
              lines[i]:=replacesubstr(lines[i],'%#%',inttostr(var_number_start.value+i),false);
           inc(i);
      end;
end;


procedure TForm1.WhiteSpacesLoeschen(Sender: TObject);
var i:integer;
    s1,sres:string;
begin
s1:=lines.text;
for i:=1 to length(s1) do
    case s1[i] of
         #13 : if not dellb.Checked then sres:=sres+s1[i];
         #10 : if not dellb.Checked then sres:=sres+s1[i];
         #32 : if not delspaces.Checked then sres:=sres+s1[i];
         #9 :  if not deltabs.Checked then sres:=sres+s1[i];
         else sres:=sres+s1[i];

    end;
lines.text:=sres;
end;


procedure TForm1.trimlines(Sender: TObject);
var i:integer;
begin
i:=0;
while i<lines.Count do
      begin
           lines[i]:=trim(lines[i]);
           inc(i);
      end;
end;


procedure TForm1.deletehtml(Sender: TObject);
var i:integer;
begin
i:=0;
while i<lines.Count do
      begin
           lines[i]:=deletehtmlcodes(lines[i]);
           inc(i);
      end;
end;

procedure TForm1.quotemailreply(Sender: TObject);
var i:integer;
begin
i:=0;
while i<lines.Count do
      begin
           lines[i]:='> '+lines[i];
           inc(i);
      end;
end;

procedure TForm1.makeparagraph(Sender: TObject);
var s:string;
    i:integer;
    r:string;
    deletenow:boolean;
begin
s:=lines.text;
s:=replacesubstr(s,#13#10,' ',false);
s:=replacesubstr(s,#10,' ',false);
i:=1;
deletenow:=false;
while i<=length(s) do
      begin
           if s[i]=' ' then
              begin
              if deletenow=false then
                 begin
                      r:=r+' ';
                      deletenow:=true;
                 end;
              end
           else
              begin
              deletenow:=false;
              r:=r+s[i];
              end;
      inc(i);
      end;
lines.text:=r;
end;

procedure TForm1.rfill(Sender: TObject);
var i:integer;
    size:integer;
begin
size:=0;
i:=0;
while i<lines.Count do
      begin
           if size<length(lines[i]) then size:=length(lines[i]);
           inc(i);
      end;
i:=0;
while i<lines.Count do
      begin
           if not rfillnonauto.checked then while size>length(lines[i]) do lines[i]:=lines[i]+chr(rfillchar.value);
           if rfillnonauto.checked then while rfillsize.value>length(lines[i]) do lines[i]:=lines[i]+chr(rfillchar.value);

           inc(i);
      end;
end;

procedure TForm1.makelinenumbers(Sender: TObject);
var start,x,width:integer;
   function makenumber(n,w:integer):string;
   var nstring:string;
   begin
   nstring:=inttostr(n);
   while length(nstring)<w do nstring:='0'+nstring;
   result:=nstring;
   end;
begin
start:=lnumberstart.value;
if lnumberuserdefine.checked then
   begin
        width:=lnumberdigits.Value;
   end
else
    begin
        x:=start+lines.count-1;
        width:=1;
        while (x div 10) > 0 do
          begin
          x:=x div 10;
          inc(width);
          end;
    end;
for x:=0 to lines.count-1 do
    lines[x]:=makenumber(x+start,width)+' '+lines[x];
end;

procedure TForm1.inserthex(Sender: TObject);
begin
     RUECKGABETYP:=RUECKGABE_ERSETZT_MARKIERUNG;
     lines.Text:=inttohex(inthex.value,0);
end;

procedure TForm1.insertbin(Sender: TObject);
var binstr:string;
    x:integer;
begin
    RUECKGABETYP:=RUECKGABE_ERSETZT_MARKIERUNG;
    x:=intbin.value;
    while x>0 do
      begin
      if (x and 1) = 1 then
         binstr:='1'+binstr
      else binstr:='0'+binstr;
      x:= x shr 1;
      end;
    lines.text:=binstr;
end;

end.
