library testplugin;

{$E .dll}

uses
  SysUtils,
  Classes;
  
const INTERFACEVERSION =1 ;

      KEINE_RUECKGABE=0; //Programmabbruch ohne Rueckgabe
      RUECKGABE_ERSETZT_MARKIERUNG = 1; // Bedeutet, dass die Rckgabe des Plugins nur den markierten Text ersetzt;
      RUECKGABE_ERSETZT_EDITORTEXT = 2; // Bedeutet, dass die Rckgabe des Plugins den gesamten Text im Editor ersetzt;


var lines:tstrings;
    RUECKGABETYP:integer;


function pluginStart(text:pchar; selstart,sellength:integer) : pchar; export;stdcall;
var i:integer;
begin
  lines:=Tstringlist.create;
  if (sellength>0) then
     begin
     RUECKGABETYP:=RUECKGABE_ERSETZT_MARKIERUNG;
     lines.text:=copy(strpas(text), selstart+1, sellength);
     end
  else
    begin
    RUECKGABETYP:=RUECKGABE_ERSETZT_EDITORTEXT;
    lines.Text:=strpas(text);
    end;

  try
    i:=0;
    while i<lines.count do
    	begin
    		lines[i]:='> '+lines[i];
    	end;
    lines.free;
    Result := StrNew(pchar(lines.text));
  except
    //Falls irgendein unerwarteter Fehler auftritt
    RUECKGABETYP:=KEINE_RUECKGABE;
    Result := '';
    lines.free;
  end;
end;



function pluginRueckgabetyp:Integer;export; stdcall;
begin
  Result := RUECKGABETYP; // RUECKGABETYP ist Variable aus UNIT DLLFORM !!
end;


function pluginInterfaceVersion:Integer;export; stdcall;
begin
  Result := INTERFACEVERSION;
end;


//Exportieren der Funktionen aus der dll
exports
pluginRueckgabetyp,
pluginStart,
pluginInterfaceVersion;

end.