library testplugin;

{$E .dll}

uses
  SysUtils,
  Classes,
  dllform in 'dllform.pas' {Form1};

const INTERFACEVERSION =1 ;

      KEINE_RUECKGABE=0; //Programmabbruch ohne Rueckgabe
      RUECKGABE_ERSETZT_MARKIERUNG = 1; // Bedeutet, dass die Rckgabe des Plugins nur den markierten Text ersetzt;
      RUECKGABE_ERSETZT_EDITORTEXT = 2; // Bedeutet, dass die Rckgabe des Plugins den gesamten Text im Editor ersetzt;


{Die folgende Funktion ist eigentlich die Kernfunktion des Plugins ,
und am wichtigsten fr Pluginentwickler ! Hier kann beliebiger Code
stehen, der den Text im Editor, bzw. die Markierung ersetzt.
bergabeparameter:
text      :  Enthlt den kompletten Text im HTML-Editor
selstart  :  Cursorposition im Editor, oder falls Text markiert
             ist , die Startposition der Markierung. Entspricht der
             Delphifunktion TMemo.selstart
sellegnth :  Lnge der Markierung. Falls kein Text markiert ist
             diese Variable 0. Entspricht der Delphifunktion
             TMemo.sellenth
Der Rckgabewert der Funktion ist ein String vom Typ pchar , ein
Nullterminierter String. Um einen Delphistring in ein pchar zu
verwandeln nutzen sie die Funktion PChar(stringvariable). Dieser
seltsamme Typ ist notwendig, weil dieser Kompatibilitt zu C++
Strings bietet. Der bergabeparameter Text ist auch ein PChar.
Diesen knnen sie mit der Funktion StrPas(pcharvariable) in einen
Delphistring umwandeln.
}

function pluginStart(text:pchar; selstart,sellength:integer) : pchar; export;stdcall;
var
  Form1 : TForm1;
  var p:string;
begin
  Form1 := TForm1.Create(nil);
  try
    Form1.Memo1.Text:=strpas(text);
    if sellength=0 then
      Form1.Label1.caption:='Der Cursor im Editor war auf Position '+inttostr(selstart)+'.'
      else Form1.Label1.caption:='Die Markierung im Editor ging von '+inttostr(selstart)+' bis '+inttostr(selstart+sellength);
    Form1.Memo1.SelStart:=selstart;
    Form1.Memo1.Sellength:=sellength;
    Form1.Memo2.Text:=copy(strpas(text), selstart+1, sellength); //Markierter Text
    //Wichtig ! Form nur Modal starten !!!!!!!!
    Form1.ShowModal;
    Result := StrNew(pchar(RUECKGABESTRING));
    Form1.Free;
  except
    //Falls irgendein unerwarteter Fehler auftritt
    RUECKGABETYP:=KEINE_RUECKGABE;
    Result := '';
    Form1.Free;
  end;
end;


{Die Rckgabe des Plugins kann entweder den gesamten Text im
Editor ersetzen, oder nur den markierten.
Diese Funktion wird vom HTML-Editor aufgrufen, NACHDEM (!) das
Plugin beendet wurde (Nach Ende von "StartPlugin" Funktion).
Der Rckgabetyp muss also nicht vorher fr das Plugin festgelegt
werden, sondern kann vom Plugin-Programmierer dynamisch gendert
werden
Die Rckgabe kann folgenede Werte annehmen (Siehe CONST)
KEINE_RUECKGABE=0;
RUECKGABE_ERSETZT_MARKIERUNG = 1;
RUECKGABE_ERSETZT_EDITORTEXT = 2;
Falls das Plugin mit dem Knopf ABBRUCH beendet wird, wird der
Rckgabetyp auf KEINE_RUECKGABE GESETZT
}

function pluginRueckgabetyp:Integer;export; stdcall;
begin
  Result := RUECKGABETYP; // RUECKGABETYP ist Variable aus UNIT DLLFORM !!
end;


{Diese Funktion ist aus kompatibilittsgrnden
notwendig, falls das Interface irgendwann
einmal gendert wird , oder erweitert wird.
Die jetztige Version ist 1 }
function pluginInterfaceVersion:Integer;export; stdcall;
begin
  Result := INTERFACEVERSION;
end;


//Exportieren der Funktionen aus der dll
exports
pluginRueckgabetyp,
pluginStart,
pluginInterfaceVersion;

end.
