#!/bin/sh

PATH=/bin:/usr/bin:/sbin:/usr/sbin
. /usr/lib/libmodcgi.sh
. /mod/etc/conf/oscam.cfg

if [ -e /var/tmp/intern ]; then
		if [ "$(mount|grep "yaffs2")" ] || [ "$(mount|grep "ubifs")" ] || [ "$(mount|grep "ext4")" ] >/dev/null; then
        OSCAM_PATH=/var/media/ftp
        BKUP_PATH=/var/media/ftp/addon/oscam
    else 
        OSCAM_PATH=/data
        BKUP_PATH=/var/tmp
    fi
else
    if [ -z "$OSCAM_PATH" ] || [ -z "$(df|grep "$OSCAM_PATH"|grep "/dev/sd")" ]; then OSCAM_PATH="$(df|grep "/dev/sda"|awk '{print $6}'|tail -1)"; fi
    BKUP_PATH="$OSCAM_PATH/addon/oscam"
fi

WORKING_DIR="$OSCAM_PATH/addon/oscam"
DAEMON=oscam

UPDATE=0;
UPD_INST_TXT_DE="installieren"
UPD_INST_TXT_EN="Install"
if [ -e "$WORKING_DIR/oscam" ]; then 
    UPDATE=1
    UPD_INST_TXT_DE="aktualisieren"
    UPD_INST_TXT_EN="Update"
fi

#cgi --id=cgi --id=extra:oscam:oscamup
cgi_begin '$(lang de:"OSCam-Setup" en:"OSCam setup")'

if [ -e "$WORKING_DIR/" ]; then

echo '
<h1>$(lang de:"OSCam-Dienst installieren oder aktualisieren" en:"Install or Update OSCam Service")</h1>
<p>
    $(lang de:"Hier k&ouml;nnen Sie den OSCam-Dienst im internen oder USB Speicher Ihrer FRITZ!BOX installieren oder aktualisieren." en:"Here you may install or update the OSCam service in internal or USB memeory of your FRITZ!BOX.")
</p>'

sec_begin '$(lang de:"Aktuelle OSCam-Version herunterladen" en:"Download Latest OSCam Release")'
    echo '
    <p>
        $(lang de:"Hier gibt es aktuelle OSCam-Binaries:" en:"Here you will find the latest OSCam binaries:")
    </p>
    <ul>
        <li><a class="active" href="https://freetz.digital-eliteboard.com/?dir=Teamserver/Freetz/OScam" target="_blank">$(lang de:"OSCam-Binary herunterladen" en:"Download OSCam binary")</a></li>
    </ul>'
sec_end

sec_begin "$(lang de:"OSCam $UPD_INST_TXT_DE" en:"$UPD_INST_TXT_EN OSCam")"
    if [ "$UPDATE" = "1" ]; then
        echo '
        <p>
            $(lang de:"Eine bestehende Installation von OSCam wurde gefunden." en:"A current installation of OSCam was found.")
            $(lang de:"Wenn Sie mit der Aktualisierung fortfahren wird eine Sicherungskopie der vorhandenen OSCam-Binary angelegt." en:"If you proceed with the update a backup copy of the current OSCam binary will be created.")
        </p>'
    else
        echo '
        <p>
            $(lang de:"Es ist noch keine OSCam-Binary im Zielverzeichnis vorhanden." en:"No OSCam binary exists in the target directory.")
            $(lang de:"Fahren Sie fort, um eine OSCam-Binary im Zielverzeichnis zu installieren." en:"Proceed to install an OSCam binary in the target directory.")
        </p>'
    fi

    echo '
    <p>
        $(lang de:"Laden Sie eine passende OSCam-Binary vom Typ <b>oscam-...-mips-freetz-...</b> zur Box hoch." en:"Upload an appropriate OSCam binary of type <b>oscam-...-mips-freetz-...</b> to your box.")
        $(lang de:"Die Datei darf <b>nicht umbenannt</b> werden." en:"Do <b>not rename</b> the file.")
    </p>
    <form action="'$(href extra oscam do_oscamexternal)'" method="POST" enctype="multipart/form-data">
        <p><input type="file" size="50" name="oscam" ></p>
        <p><input type="submit" value="$(lang de:"OSCam '$UPD_INST_TXT_DE'" en:"$UPD_INST_TXT_EN OSCam")" style="width:180px"></p>
    </form>'
sec_end

if [ -e "$BKUP_PATH/${DAEMON}_old" ]; then
    sec_begin '$(lang de:"OSCam-Dienst aus Backup wiederherstellen" en:"Restore OSCam Service from Backup")'
        echo '
        <p>
            $(lang de:"Wenn das Update nicht erfolgreich war - z.B. OSCam l&auml;sst sich nach dem Update nicht mehr starten - " en:"If the update was not successful - e.g. OSCam does not start after the update -") 
            $(lang de:"haben Sie die M&ouml;glichkeit den urspr&uuml;nglichen Zustand wieder herzustellen." en:"you have the option to restore the previous state.")
        </p>
        <p>
            <form action="'$(href extra oscam do_oscambackup)'"><div class="btn"><input type="submit" value="$(lang de:"OSCam wiederherstellen" en:"Restore OSCam")" style="width:180px"></div></form>
        </p>'
    sec_end
fi

echo '
    <p>
        <input type="checkbox" name="expertchk" value="no" onclick='\''document.getElementById("expertchk_show").style.display=(this.checked)? "" : "none"'\''> 
        $(lang de:"Zusatz-Optionen anzeigen" en:"Show additional options")
    </p>'

echo '<div id="expertchk_show" style="display:none;margin-left:0px;" name="expertchk_show">'

sec_begin '$(lang de:"OSCam-Konfiguration sichern oder wiederherstellen" en:"Backup or Restore OSCam Configuration")'
    echo '
    <h1>$(lang de:"Sicherung" en:"Backup")</h1>
    <p>
        $(lang de:"Sichern der aktuellen OSCam-Konigurationsdateien als Archiv auf Ihrem PC." en:"Backup the current OSCam configuration files to an archive on your PC.")
    </p>
    <form action="'$(href extra oscam do_configbackup)'" method="GET">
        <p><input type=submit value="$(lang de:"Sichern" en:"Backup")" style="width:180px"></p>
    </form>

    <h1>$(lang de:"Wiederherstellung" en:"Restore")</h1>
    <p>
        $(lang de:"Wiederherstellen der OSCam-Konfiguration aus einem zuvor gesicherten Archiv." en:"Restore the OSCam configuration from a backup archive.")
    </p>
    <form action="'$(href extra oscam do_configrestore)'" method="POST" enctype="multipart/form-data">
        <p><input type="file" size="50" name="uploadfile"></p>
        <p><input type="checkbox" name="replace" id="replace"><label for="replace">$(lang de:"Pfade in oscam.conf (logfile, httpcss) automatisch anpassen" en:"Automatically adapt path settings in oscam.conf (logfile, httpcss)")</label></p>
        <p><input type="checkbox" name="restart" id="restart" checked><label for="restart">$(lang de:"OSCam-Neustart nach Wiederherstellung" en:"Restart OSCam after restore")</label></p>
        <p><input type="submit" value="$(lang de:"Wiederherstellen" en:"Restore")" style="width:180px"></p>
    </form>'
sec_end

sec_begin '$(lang de:"Speicher bereinigen" en:"Clean Up Memory")'
    echo '
    <p>
        $(lang de:"Bei (zu) geringem Speicherplatz sollten Sie vorhandene Binaries, " en:"If memory is (too) short you should remove existing binaries,")
        $(lang de:"SoftCam.Key, Skins, Logdateien und Konfigurationsbackups entfernen." en:" SoftCam.Key, skins, log files and configuration backups.") 
    </p>
    <form action="'$(href extra oscam do_cleanup)'" method="POST" enctype="multipart/form-data">
        <p><input type="submit" value="$(lang de:"Bereinigen" en:"Clean up")" style="width:180px"></p>
    </form>'
sec_end

if [ -e "$WORKING_DIR/$DAEMON" ]; then
    sec_begin '$(lang de:"list_smargo installieren/aktualisieren" en:"Install/Update list_smargo")'
        echo '
        <p>
            $(lang de:"<b>ACHTUNG!</b> Dieser Schritt ist optional und kann ggf. &uuml;bersprungen werden." en:"CAUTION! This step is optional and may be omitted.")
        </p>
        <p>
            $(lang de:"Laden Sie eine passende <b>list_smargo-...-mips-freetz-...</b> zur Box hoch." en:"Upload an appropriate <b>list_smargo-...-mips-freetz-...</b> to your box.") 
            $(lang de:"Die Datei darf <b>nicht umbenannt</b> werden." en:"Do <b>not rename</b> the file.")
        </p>
        <form action="'$(href extra oscam do_listexternal)'" method="POST" enctype="multipart/form-data">
            <p><input type="file" size="50" name="list_smargo"></p>
            <p><input type="submit" value="$(lang de:"list_smargo aktualisieren" en:"Update list_smargo")" style="width:180px"></p>
        </form>'
    sec_end

    sec_begin '$(lang de:"SoftCam.Key installieren/aktualisieren" en:"Install/Update SoftCam.Key")'
        echo '
        <p>
            $(lang de:"Laden Sie eine passende <b>SoftCam.Key</b> zur Box hoch." en:"Upload an appropriate <b>SoftCam.Key</b> to your box.") 
            $(lang de:"Die Datei darf <b>nicht umbenannt</b> werden." en:"Do <b>not rename</b> the file.")
        </p>
        <form action="'$(href extra oscam do_softcamkeyexternal)'" method="POST" enctype="multipart/form-data">
            <p><input type="file" size="50" name="softcamkey" ></p>
            <p><input type="submit" value="$(lang de:"SoftCam.Key aktualisieren" en:"Update SoftCam.Key")" style="width:180px"></p>
        </form>'
    sec_end
fi  
else
echo '
<p>$(lang de:"OSCam-Setup steht erst nach Installation der OSCam Konfigurationsdateien zur Verfgung." en:"OSCam setup is only available after installing the OSCam Configuration files.")</p>
<hr />'  
fi

echo '</div><form action="'$(href conf oscam)'"><div class="btn"><input type="submit" value="$(lang de:"Zur&uuml;ck" en:"Back")"></div></form>'

cgi_end
